#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Zooming Trippy PlasmaMod01.fsh   by   Optimus  
//https://www.shadertoy.com/view/MstcR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float plasma(vec2 p, float iso, float fade)
{
	float c = 0.0;
	for (float i=1.0; i<10.0; ++i) {
		float f1 = i / 0.6;
		float f2 = i / 0.3;
		float f3 = i / 0.7;
		float f4 = i / 0.5;
		float s1 = i / 2.0;
		float s2 = i / 4.0;
		float s3 = i / 3.0;
		c += sin(p.x * f1 + iTime) * s1 + sin(p.y * f2 + 0.5 * iTime) * s2 + sin(p.x * f3 + p.y * f4 - 1.5 * iTime) * s3;
	}
	//c = mod(clamp(c, -1.0, 1.0), 0.5) * 2.0;
	c = mod(c, 16.0) * 0.5 - 7.0;
	if (c < iso) {
		return 0.0;
	}
	else {
		if (c > 0.5) c = 1.0 - c;
		c *= 2.0;
		return c * fade;
	}
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

	vec2 pos = (( fragCoord.xy / iResolution.xy ) - vec2(0.5)) * vec2(iResolution.x / iResolution.y, 1.0);

	float c = 0.0;
	for (float i=0.0; i<27.0; ++i)
	{
		float patazoom = mod(0.5 * iTime, 1.0);
		float zoom = 1.0 + i - patazoom;
		vec2 trans = vec2(sin(iTime * 0.3) * 0.5, sin(iTime * 0.4) * 0.2);
		c = plasma(pos * zoom + trans, 0.0, 2.0 / (1.0 + i - patazoom));
		if (c> 0.001) break;
	}
	fragColor = vec4(c * pos.x, c * pos.y, c * abs(pos.x + pos.y), 0.5) * 2.0;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

